using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Windows.Forms;

using gov.va.med.vbecs.Common;

namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Class DlgPatientAvailabilityType
	/// </summary>
	public class DlgPatientAvailabilityType : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		private BOL.BloodAvailability _bloodAvailability;
		//
		private System.Windows.Forms.GroupBox grpImage;
		private System.Windows.Forms.PictureBox pictureBox1;
		private System.Windows.Forms.Button btnCancel;
		private System.Windows.Forms.GroupBox grpType;
		private System.Windows.Forms.GroupBox grpDivisions;
		private System.Windows.Forms.RadioButton rdoCustom;
		private System.Windows.Forms.RadioButton rdoNoDisposition;
		private System.Windows.Forms.RadioButton rdoAntigenTyped;
		private System.Windows.Forms.RadioButton rdoAvailableUnits;
		private System.Windows.Forms.RadioButton rdoAllUnits;
		private System.Windows.Forms.RadioButton rdoPatient;
		private System.Windows.Forms.RadioButton rdoCurrentDivision;
		private System.Windows.Forms.RadioButton rdoAllDivisions;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;
		private System.Windows.Forms.GroupBox grpReportCompilation;
		private System.Windows.Forms.RadioButton rdoScheduleJob;
		private System.Windows.Forms.RadioButton rdoCreateNow;
		private System.Windows.Forms.GroupBox grpScheduleJob;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbPrinterName;
		private System.Windows.Forms.Label lblPrinterName;
		private System.Windows.Forms.Label lblPrintDate;
		private System.Windows.Forms.DateTimePicker dtpPrintDate;
		private System.Windows.Forms.GroupBox grpPatient;
		private System.Windows.Forms.Button btnSelectPatient;
		private System.Windows.Forms.TextBox txtPatientID;
		private System.Windows.Forms.TextBox txtPatientName;
		private System.Windows.Forms.Label lblPatientID;
		private System.Windows.Forms.Label lblPatientName;
		private System.Windows.Forms.RadioButton rdoFinalDisposition;
		private System.Windows.Forms.GroupBox grpDateRange;
		private System.Windows.Forms.Label lblEndDate;
		private System.Windows.Forms.Label lblStartDate;
		private System.Windows.Forms.DateTimePicker dtpStartDate;
		private System.Windows.Forms.DateTimePicker dtpEndDate;
		private System.ComponentModel.IContainer components = null;

		/// <summary>
		/// Constructor
		/// </summary>
		public DlgPatientAvailabilityType()
		{
			// This call is required by the Windows Form Designer.
			InitializeComponent();
			//
			this._bloodAvailability = new BOL.BloodAvailability();
			this._bloodAvailability.Valid += new System.EventHandler(this.CheckValid);
			this._bloodAvailability.Invalid += new System.EventHandler(this.CheckValid);
			this._bloodAvailability.IsDirtyChanged += new System.EventHandler(this.CheckValid);
			this._bloodAvailability.SetInitialBrokenRules(this.Name);
			//
			SetComponentProperties();
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(DlgPatientAvailabilityType));
			this.grpImage = new System.Windows.Forms.GroupBox();
			this.pictureBox1 = new System.Windows.Forms.PictureBox();
			this.btnCancel = new System.Windows.Forms.Button();
			this.grpType = new System.Windows.Forms.GroupBox();
			this.rdoFinalDisposition = new System.Windows.Forms.RadioButton();
			this.rdoCustom = new System.Windows.Forms.RadioButton();
			this.rdoNoDisposition = new System.Windows.Forms.RadioButton();
			this.rdoAntigenTyped = new System.Windows.Forms.RadioButton();
			this.rdoAvailableUnits = new System.Windows.Forms.RadioButton();
			this.rdoAllUnits = new System.Windows.Forms.RadioButton();
			this.rdoPatient = new System.Windows.Forms.RadioButton();
			this.grpPatient = new System.Windows.Forms.GroupBox();
			this.btnSelectPatient = new System.Windows.Forms.Button();
			this.txtPatientID = new System.Windows.Forms.TextBox();
			this.txtPatientName = new System.Windows.Forms.TextBox();
			this.lblPatientID = new System.Windows.Forms.Label();
			this.lblPatientName = new System.Windows.Forms.Label();
			this.grpDateRange = new System.Windows.Forms.GroupBox();
			this.lblEndDate = new System.Windows.Forms.Label();
			this.lblStartDate = new System.Windows.Forms.Label();
			this.dtpStartDate = new System.Windows.Forms.DateTimePicker();
			this.dtpEndDate = new System.Windows.Forms.DateTimePicker();
			this.grpDivisions = new System.Windows.Forms.GroupBox();
			this.rdoAllDivisions = new System.Windows.Forms.RadioButton();
			this.rdoCurrentDivision = new System.Windows.Forms.RadioButton();
			this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.grpReportCompilation = new System.Windows.Forms.GroupBox();
			this.rdoScheduleJob = new System.Windows.Forms.RadioButton();
			this.rdoCreateNow = new System.Windows.Forms.RadioButton();
			this.grpScheduleJob = new System.Windows.Forms.GroupBox();
			this.cmbPrinterName = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
			this.lblPrinterName = new System.Windows.Forms.Label();
			this.lblPrintDate = new System.Windows.Forms.Label();
			this.dtpPrintDate = new System.Windows.Forms.DateTimePicker();
			this.grpImage.SuspendLayout();
			this.grpType.SuspendLayout();
			this.grpPatient.SuspendLayout();
			this.grpDateRange.SuspendLayout();
			this.grpDivisions.SuspendLayout();
			this.grpReportCompilation.SuspendLayout();
			this.grpScheduleJob.SuspendLayout();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(412, 30);
			this.vbecsLogo1.TabIndex = 5;
			this.vbecsLogo1.Title = "Blood Availability Report";
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 489);
			this.lblRequiredField.Name = "lblRequiredField";
			this.lblRequiredField.TabIndex = 7;
			// 
			// grpImage
			// 
			this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.grpImage.BackColor = System.Drawing.SystemColors.Control;
			this.grpImage.Controls.Add(this.pictureBox1);
			this.grpImage.Location = new System.Drawing.Point(4, 32);
			this.grpImage.Name = "grpImage";
			this.grpImage.Size = new System.Drawing.Size(52, 436);
			this.grpImage.TabIndex = 6;
			this.grpImage.TabStop = false;
			// 
			// pictureBox1
			// 
			this.pictureBox1.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox1.Image")));
			this.pictureBox1.Location = new System.Drawing.Point(2, 16);
			this.pictureBox1.Name = "pictureBox1";
			this.pictureBox1.Size = new System.Drawing.Size(45, 45);
			this.pictureBox1.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.pictureBox1.TabIndex = 38;
			this.pictureBox1.TabStop = false;
			// 
			// btnCancel
			// 
			this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.Location = new System.Drawing.Point(334, 471);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.TabIndex = 4;
			this.btnCancel.Text = "&Cancel";
			this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
			// 
			// grpType
			// 
			this.grpType.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpType.Controls.Add(this.rdoFinalDisposition);
			this.grpType.Controls.Add(this.rdoCustom);
			this.grpType.Controls.Add(this.rdoNoDisposition);
			this.grpType.Controls.Add(this.rdoAntigenTyped);
			this.grpType.Controls.Add(this.rdoAvailableUnits);
			this.grpType.Controls.Add(this.rdoAllUnits);
			this.grpType.Controls.Add(this.rdoPatient);
			this.grpType.Controls.Add(this.grpPatient);
			this.grpType.Controls.Add(this.grpDateRange);
			this.grpType.Location = new System.Drawing.Point(60, 32);
			this.grpType.Name = "grpType";
			this.grpType.Size = new System.Drawing.Size(348, 256);
			this.grpType.TabIndex = 0;
			this.grpType.TabStop = false;
			this.grpType.Text = "Blood Availability Report Type*";
			// 
			// rdoFinalDisposition
			// 
			this.rdoFinalDisposition.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.rdoFinalDisposition.Location = new System.Drawing.Point(16, 96);
			this.rdoFinalDisposition.Name = "rdoFinalDisposition";
			this.rdoFinalDisposition.Size = new System.Drawing.Size(256, 20);
			this.rdoFinalDisposition.TabIndex = 4;
			this.rdoFinalDisposition.Text = "Units with &Final Disposition (Not Transfused)";
			this.rdoFinalDisposition.CheckedChanged += new System.EventHandler(this.ReportTypeChanged);
			// 
			// rdoCustom
			// 
			this.rdoCustom.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.hlphelpChm.SetHelpNavigator(this.rdoCustom, System.Windows.Forms.HelpNavigator.Topic);
			this.hlphelpChm.SetHelpString(this.rdoCustom, "Blood_Availability.htm");
			this.rdoCustom.Location = new System.Drawing.Point(16, 152);
			this.rdoCustom.Name = "rdoCustom";
			this.hlphelpChm.SetShowHelp(this.rdoCustom, true);
			this.rdoCustom.Size = new System.Drawing.Size(328, 20);
			this.rdoCustom.TabIndex = 5;
			this.rdoCustom.Text = "C&ustom Report";
			this.rdoCustom.CheckedChanged += new System.EventHandler(this.ReportTypeChanged);
			// 
			// rdoNoDisposition
			// 
			this.rdoNoDisposition.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.rdoNoDisposition.Location = new System.Drawing.Point(16, 76);
			this.rdoNoDisposition.Name = "rdoNoDisposition";
			this.rdoNoDisposition.Size = new System.Drawing.Size(328, 20);
			this.rdoNoDisposition.TabIndex = 3;
			this.rdoNoDisposition.Text = "Units &with No Disposition (Available Expired)";
			this.rdoNoDisposition.CheckedChanged += new System.EventHandler(this.ReportTypeChanged);
			// 
			// rdoAntigenTyped
			// 
			this.rdoAntigenTyped.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.rdoAntigenTyped.Location = new System.Drawing.Point(16, 56);
			this.rdoAntigenTyped.Name = "rdoAntigenTyped";
			this.rdoAntigenTyped.Size = new System.Drawing.Size(328, 20);
			this.rdoAntigenTyped.TabIndex = 2;
			this.rdoAntigenTyped.Text = "Antigen &Typed Inventory (Available Units)";
			this.rdoAntigenTyped.CheckedChanged += new System.EventHandler(this.ReportTypeChanged);
			// 
			// rdoAvailableUnits
			// 
			this.rdoAvailableUnits.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.rdoAvailableUnits.Location = new System.Drawing.Point(16, 36);
			this.rdoAvailableUnits.Name = "rdoAvailableUnits";
			this.rdoAvailableUnits.Size = new System.Drawing.Size(328, 20);
			this.rdoAvailableUnits.TabIndex = 1;
			this.rdoAvailableUnits.Text = "Daily Inventory (A&vailable Units)";
			this.rdoAvailableUnits.CheckedChanged += new System.EventHandler(this.ReportTypeChanged);
			// 
			// rdoAllUnits
			// 
			this.rdoAllUnits.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.rdoAllUnits.Location = new System.Drawing.Point(16, 16);
			this.rdoAllUnits.Name = "rdoAllUnits";
			this.rdoAllUnits.Size = new System.Drawing.Size(328, 20);
			this.rdoAllUnits.TabIndex = 0;
			this.rdoAllUnits.TabStop = true;
			this.rdoAllUnits.Text = "Daily &Inventory (All Units)";
			this.rdoAllUnits.CheckedChanged += new System.EventHandler(this.ReportTypeChanged);
			// 
			// rdoPatient
			// 
			this.rdoPatient.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.rdoPatient.Location = new System.Drawing.Point(16, 172);
			this.rdoPatient.Name = "rdoPatient";
			this.rdoPatient.Size = new System.Drawing.Size(244, 20);
			this.rdoPatient.TabIndex = 6;
			this.rdoPatient.Text = "Individual &Patient Blood Availability ";
			this.rdoPatient.CheckedChanged += new System.EventHandler(this.PatientReportTypeChanged);
			// 
			// grpPatient
			// 
			this.grpPatient.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpPatient.Controls.Add(this.btnSelectPatient);
			this.grpPatient.Controls.Add(this.txtPatientID);
			this.grpPatient.Controls.Add(this.txtPatientName);
			this.grpPatient.Controls.Add(this.lblPatientID);
			this.grpPatient.Controls.Add(this.lblPatientName);
			this.grpPatient.Enabled = false;
			this.grpPatient.Location = new System.Drawing.Point(8, 176);
			this.grpPatient.Name = "grpPatient";
			this.grpPatient.Size = new System.Drawing.Size(332, 72);
			this.grpPatient.TabIndex = 8;
			this.grpPatient.TabStop = false;
			// 
			// btnSelectPatient
			// 
			this.btnSelectPatient.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.btnSelectPatient.Font = new System.Drawing.Font("Arial", 5.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnSelectPatient.Location = new System.Drawing.Point(304, 20);
			this.btnSelectPatient.Name = "btnSelectPatient";
			this.btnSelectPatient.Size = new System.Drawing.Size(24, 20);
			this.btnSelectPatient.TabIndex = 1;
			this.btnSelectPatient.Text = "find";
			this.btnSelectPatient.Click += new System.EventHandler(this.btnSelectPatient_Click);
			// 
			// txtPatientID
			// 
			this.txtPatientID.Location = new System.Drawing.Point(76, 44);
			this.txtPatientID.Name = "txtPatientID";
			this.txtPatientID.ReadOnly = true;
			this.txtPatientID.Size = new System.Drawing.Size(192, 20);
			this.txtPatientID.TabIndex = 4;
			this.txtPatientID.Text = "";
			// 
			// txtPatientName
			// 
			this.txtPatientName.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtPatientName.Location = new System.Drawing.Point(76, 20);
			this.txtPatientName.Name = "txtPatientName";
			this.txtPatientName.ReadOnly = true;
			this.txtPatientName.Size = new System.Drawing.Size(228, 20);
			this.txtPatientName.TabIndex = 2;
			this.txtPatientName.Text = "";
			// 
			// lblPatientID
			// 
			this.lblPatientID.Location = new System.Drawing.Point(8, 44);
			this.lblPatientID.Name = "lblPatientID";
			this.lblPatientID.Size = new System.Drawing.Size(100, 20);
			this.lblPatientID.TabIndex = 3;
			this.lblPatientID.Text = "Patient ID*";
			this.lblPatientID.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblPatientName
			// 
			this.lblPatientName.Location = new System.Drawing.Point(8, 20);
			this.lblPatientName.Name = "lblPatientName";
			this.lblPatientName.Size = new System.Drawing.Size(100, 20);
			this.lblPatientName.TabIndex = 0;
			this.lblPatientName.Text = "Patient Name*";
			this.lblPatientName.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// grpDateRange
			// 
			this.grpDateRange.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpDateRange.Controls.Add(this.lblEndDate);
			this.grpDateRange.Controls.Add(this.lblStartDate);
			this.grpDateRange.Controls.Add(this.dtpStartDate);
			this.grpDateRange.Controls.Add(this.dtpEndDate);
			this.grpDateRange.Location = new System.Drawing.Point(8, 100);
			this.grpDateRange.Name = "grpDateRange";
			this.grpDateRange.Size = new System.Drawing.Size(328, 48);
			this.grpDateRange.TabIndex = 7;
			this.grpDateRange.TabStop = false;
			// 
			// lblEndDate
			// 
			this.lblEndDate.Location = new System.Drawing.Point(160, 20);
			this.lblEndDate.Name = "lblEndDate";
			this.lblEndDate.Size = new System.Drawing.Size(56, 20);
			this.lblEndDate.TabIndex = 2;
			this.lblEndDate.Text = "End Date*";
			this.lblEndDate.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblStartDate
			// 
			this.lblStartDate.Location = new System.Drawing.Point(8, 20);
			this.lblStartDate.Name = "lblStartDate";
			this.lblStartDate.Size = new System.Drawing.Size(60, 20);
			this.lblStartDate.TabIndex = 0;
			this.lblStartDate.Text = "Start Date*";
			this.lblStartDate.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// dtpStartDate
			// 
			this.dtpStartDate.CalendarFont = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.dtpStartDate.CustomFormat = "MM/dd/yyyy";
			this.dtpStartDate.Enabled = false;
			this.dtpStartDate.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
			this.dtpStartDate.Location = new System.Drawing.Point(68, 20);
			this.dtpStartDate.Name = "dtpStartDate";
			this.dtpStartDate.Size = new System.Drawing.Size(88, 20);
			this.dtpStartDate.TabIndex = 1;
			this.dtpStartDate.Value = new System.DateTime(2004, 4, 7, 0, 0, 0, 0);
			this.dtpStartDate.EnabledChanged += new System.EventHandler(this.dtpStartDate_EnabledChanged);
			this.dtpStartDate.ValueChanged += new System.EventHandler(this.StartDateChanged);
			// 
			// dtpEndDate
			// 
			this.dtpEndDate.CalendarFont = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.dtpEndDate.CustomFormat = "MM/dd/yyyy";
			this.dtpEndDate.Enabled = false;
			this.dtpEndDate.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
			this.dtpEndDate.Location = new System.Drawing.Point(216, 20);
			this.dtpEndDate.Name = "dtpEndDate";
			this.dtpEndDate.Size = new System.Drawing.Size(88, 20);
			this.dtpEndDate.TabIndex = 3;
			this.dtpEndDate.Value = new System.DateTime(2004, 4, 7, 0, 0, 0, 0);
			this.dtpEndDate.EnabledChanged += new System.EventHandler(this.dtpEndDate_EnabledChanged);
			this.dtpEndDate.ValueChanged += new System.EventHandler(this.EndDateChanged);
			// 
			// grpDivisions
			// 
			this.grpDivisions.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpDivisions.Controls.Add(this.rdoAllDivisions);
			this.grpDivisions.Controls.Add(this.rdoCurrentDivision);
			this.grpDivisions.Location = new System.Drawing.Point(60, 288);
			this.grpDivisions.Name = "grpDivisions";
			this.grpDivisions.Size = new System.Drawing.Size(348, 64);
			this.grpDivisions.TabIndex = 1;
			this.grpDivisions.TabStop = false;
			this.grpDivisions.Text = "Division*";
			// 
			// rdoAllDivisions
			// 
			this.rdoAllDivisions.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.rdoAllDivisions.Location = new System.Drawing.Point(16, 36);
			this.rdoAllDivisions.Name = "rdoAllDivisions";
			this.rdoAllDivisions.Size = new System.Drawing.Size(328, 20);
			this.rdoAllDivisions.TabIndex = 1;
			this.rdoAllDivisions.Text = "&All Divisions";
			this.rdoAllDivisions.CheckedChanged += new System.EventHandler(this.DivisionChanged);
			// 
			// rdoCurrentDivision
			// 
			this.rdoCurrentDivision.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.rdoCurrentDivision.Checked = true;
			this.rdoCurrentDivision.Location = new System.Drawing.Point(16, 16);
			this.rdoCurrentDivision.Name = "rdoCurrentDivision";
			this.rdoCurrentDivision.Size = new System.Drawing.Size(328, 20);
			this.rdoCurrentDivision.TabIndex = 0;
			this.rdoCurrentDivision.TabStop = true;
			this.rdoCurrentDivision.Text = "Current &Division";
			this.rdoCurrentDivision.CheckedChanged += new System.EventHandler(this.DivisionChanged);
			// 
			// btnOK
			// 
			this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnOK.EnabledButton = false;
			this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnOK.Image = null;
			this.btnOK.Location = new System.Drawing.Point(254, 471);
			this.btnOK.Name = "btnOK";
			this.btnOK.Size = new System.Drawing.Size(75, 23);
			this.btnOK.TabIndex = 3;
			this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
			this.btnOK.MouseHover += new System.EventHandler(this.btnOK_MouseHover);
			// 
			// grpReportCompilation
			// 
			this.grpReportCompilation.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpReportCompilation.Controls.Add(this.rdoScheduleJob);
			this.grpReportCompilation.Controls.Add(this.rdoCreateNow);
			this.grpReportCompilation.Controls.Add(this.grpScheduleJob);
			this.grpReportCompilation.Location = new System.Drawing.Point(60, 352);
			this.grpReportCompilation.Name = "grpReportCompilation";
			this.grpReportCompilation.Size = new System.Drawing.Size(348, 116);
			this.grpReportCompilation.TabIndex = 2;
			this.grpReportCompilation.TabStop = false;
			this.grpReportCompilation.Text = "Report Compilation*";
			// 
			// rdoScheduleJob
			// 
			this.rdoScheduleJob.Location = new System.Drawing.Point(16, 36);
			this.rdoScheduleJob.Name = "rdoScheduleJob";
			this.rdoScheduleJob.Size = new System.Drawing.Size(120, 16);
			this.rdoScheduleJob.TabIndex = 1;
			this.rdoScheduleJob.Text = "&Schedule Print Job";
			this.rdoScheduleJob.CheckedChanged += new System.EventHandler(this.ReportCompilationChanged);
			// 
			// rdoCreateNow
			// 
			this.rdoCreateNow.Checked = true;
			this.rdoCreateNow.Location = new System.Drawing.Point(16, 16);
			this.rdoCreateNow.Name = "rdoCreateNow";
			this.rdoCreateNow.Size = new System.Drawing.Size(124, 16);
			this.rdoCreateNow.TabIndex = 0;
			this.rdoCreateNow.TabStop = true;
			this.rdoCreateNow.Text = "Create Report &Now";
			this.rdoCreateNow.CheckedChanged += new System.EventHandler(this.ReportCompilationChanged);
			// 
			// grpScheduleJob
			// 
			this.grpScheduleJob.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpScheduleJob.Controls.Add(this.cmbPrinterName);
			this.grpScheduleJob.Controls.Add(this.lblPrinterName);
			this.grpScheduleJob.Controls.Add(this.lblPrintDate);
			this.grpScheduleJob.Controls.Add(this.dtpPrintDate);
			this.grpScheduleJob.Enabled = false;
			this.grpScheduleJob.Location = new System.Drawing.Point(8, 36);
			this.grpScheduleJob.Name = "grpScheduleJob";
			this.grpScheduleJob.Size = new System.Drawing.Size(332, 72);
			this.grpScheduleJob.TabIndex = 2;
			this.grpScheduleJob.TabStop = false;
			// 
			// cmbPrinterName
			// 
			this.cmbPrinterName.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cmbPrinterName.Interval = 500;
			this.cmbPrinterName.Location = new System.Drawing.Point(96, 44);
			this.cmbPrinterName.MaxLength = 50;
			this.cmbPrinterName.Name = "cmbPrinterName";
			this.cmbPrinterName.Size = new System.Drawing.Size(228, 22);
			this.cmbPrinterName.TabIndex = 3;
			this.cmbPrinterName.SelectedIndexChanged += new System.EventHandler(this.PrinterNameChanged);
			// 
			// lblPrinterName
			// 
			this.lblPrinterName.Location = new System.Drawing.Point(24, 44);
			this.lblPrinterName.Name = "lblPrinterName";
			this.lblPrinterName.Size = new System.Drawing.Size(76, 20);
			this.lblPrinterName.TabIndex = 2;
			this.lblPrinterName.Text = "Printer Name*";
			this.lblPrinterName.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblPrintDate
			// 
			this.lblPrintDate.Location = new System.Drawing.Point(24, 20);
			this.lblPrintDate.Name = "lblPrintDate";
			this.lblPrintDate.Size = new System.Drawing.Size(72, 20);
			this.lblPrintDate.TabIndex = 0;
			this.lblPrintDate.Text = "Print Date*";
			this.lblPrintDate.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// dtpPrintDate
			// 
			this.dtpPrintDate.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.dtpPrintDate.CalendarFont = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.dtpPrintDate.CustomFormat = "MM/dd/yyyy hh:mm";
			this.dtpPrintDate.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
			this.dtpPrintDate.Location = new System.Drawing.Point(96, 20);
			this.dtpPrintDate.Name = "dtpPrintDate";
			this.dtpPrintDate.Size = new System.Drawing.Size(228, 20);
			this.dtpPrintDate.TabIndex = 1;
			this.dtpPrintDate.Value = new System.DateTime(2003, 6, 20, 15, 24, 4, 467);
			this.dtpPrintDate.ValueChanged += new System.EventHandler(this.PrintDateChanged);
			// 
			// DlgPatientAvailabilityType
			// 
			this.AcceptButton = this.btnOK;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(412, 505);
			this.Controls.Add(this.grpReportCompilation);
			this.Controls.Add(this.btnOK);
			this.Controls.Add(this.grpDivisions);
			this.Controls.Add(this.grpType);
			this.Controls.Add(this.grpImage);
			this.Controls.Add(this.btnCancel);
			this.hlphelpChm.SetHelpKeyword(this, "Blood_Availability.htm");
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.MinimumSize = new System.Drawing.Size(420, 532);
			this.Name = "DlgPatientAvailabilityType";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.Text = "VBECS - Blood Availability Report";
			this.Click += new System.EventHandler(this.btnOK_Click);
			this.KeyDownSpeakMessage += new gov.va.med.vbecs.GUI.VbecsBaseForm.KeyDownSpeakMessageEventHandler(this.DlgPatientAvailabilityType_KeyDownSpeakMessage);
			this.MouseHover += new System.EventHandler(this.btnOK_MouseHover);
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.Controls.SetChildIndex(this.btnCancel, 0);
			this.Controls.SetChildIndex(this.grpImage, 0);
			this.Controls.SetChildIndex(this.grpType, 0);
			this.Controls.SetChildIndex(this.grpDivisions, 0);
			this.Controls.SetChildIndex(this.btnOK, 0);
			this.Controls.SetChildIndex(this.grpReportCompilation, 0);
			this.grpImage.ResumeLayout(false);
			this.grpType.ResumeLayout(false);
			this.grpPatient.ResumeLayout(false);
			this.grpDateRange.ResumeLayout(false);
			this.grpDivisions.ResumeLayout(false);
			this.grpReportCompilation.ResumeLayout(false);
			this.grpScheduleJob.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion
		
		private void SetComponentProperties()
		{
			this.btnOK.EnabledButton = false;
			this.btnOK.Text = "&OK";
			//
			this.vbecsLogo1.Title = this.Text.Replace("VBECS - ","");
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			//
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC049.DlgPatientAvailabilityType());
			this.SetThisHelpFile(this.rdoCustom, Common.StrRes.HelpFiles.UC049.DlgBloodAvailabilitySearch());
			//
			this.SetThisToolTip(btnCancel,Common.StrRes.Tooltips.Common.Cancel());
			this.btnOK.SetToolTip(Common.StrRes.Tooltips.UC049.SelectReportType().ResString);
			//
			this.dtpStartDate.CustomFormat = " ";
			this.dtpEndDate.CustomFormat = " ";
			this.dtpPrintDate.CustomFormat = Common.VBECSDateTime.DateTimeFormat;
			System.DateTime currentDate = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
			this.dtpPrintDate.Value = currentDate;
			this.dtpStartDate.Value = currentDate.Date.AddDays(-1);
			this.dtpEndDate.Value = currentDate.Date.AddDays(-1);

			if (ThisUser.DivisionsAndRoles.EffectiveDivisions.Count == 1)
			{
				this.rdoAllDivisions.Enabled = false;
			}

			LoadPrinters();

		}

		private void LoadPrinters()
		{
			this.cmbPrinterName.Items.Clear();
			//
			foreach (string printerName in BOL.VbecsReport.GetPrinters())
			{
				cmbPrinterName.Items.Add(printerName);
			}
		}

		private void PrintDateChanged(object sender, System.EventArgs e)
		{
			if (this._bloodAvailability.IsScheduled)
			{
				this._bloodAvailability.PrintDate = this.dtpPrintDate.Value;
			}
			//
			CheckDates();
		}

		private void PrinterNameChanged(object sender, System.EventArgs e)
		{
			if (this._bloodAvailability.IsScheduled)
			{
				if(cmbPrinterName.SelectedItem!=null)
				{
					string printer=this.cmbPrinterName.Text;
					for(int i=0; i<this.cmbPrinterName.Items.Count; i++)
					{
						if(printer==this.cmbPrinterName.Items[i].ToString())
						{
							this._bloodAvailability.PrinterName = cmbPrinterName.SelectedItem.ToString();
						}
					}
				}		
				else
				{
					this._bloodAvailability.PrinterName=String.Empty;
				}
			}
		}

		private void CheckValid(object sender, System.EventArgs e)
		{
			this.btnOK.EnabledButton = (this._bloodAvailability.IsValid);
		}

		private bool CheckReportLength(int count)
		{
			if(count==0)
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC049.NoInfoReturned());
				return false;
			}
			//
			if((count/25)>=50)
			{
				// Alert user about page count.
				DialogResult result = GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.UC049.PageCountAlert());
				//
				if( result != DialogResult.Yes )
				{
					return false;
				}
				else
				{
					GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC049.Warning());
				}
			}
			//
			return true;
		}

		private void btnOK_Click(object sender, System.EventArgs e)
		{
			if (this._bloodAvailability.IsCustomReport)
			{
				int nCount = 0;
				DlgBloodAvailabilitySearch dbas=new DlgBloodAvailabilitySearch(this.rdoCurrentDivision.Checked);
				if(dbas.ShowDialog(this.ParentForm)==DialogResult.OK)
				{
					this.Refresh();
					// Clear and then populate the array list filters, with data from the Blood 
					// Availability search screen.
					nCount = dbas.ComponentClasses.Count;
					for(int i=0; i<nCount; i++)
						this._bloodAvailability.AddComponentClassFilter(dbas.ComponentClasses[i].ToString());
					nCount = dbas.Divisions.Count;
					for(int i=0; i<nCount; i++)
						this._bloodAvailability.AddDivisionFilter(dbas.Divisions[i].ToString());
					nCount = dbas.DonationTypes.Count;
					for(int i=0; i<nCount; i++)
						this._bloodAvailability.AddDonationTypeFilter(dbas.DonationTypes[i].ToString());
					nCount = dbas.ProductAttributes.Count;
					for(int i=0; i<nCount; i++)
						this._bloodAvailability.AddProductAttributeFilter(dbas.ProductAttributes[i].ToString());
					nCount = dbas.AboRh.Count;
					for(int i=0; i<nCount; i++)
						this._bloodAvailability.AddABORhFilter(dbas.AboRh[i].ToString());
					nCount = dbas.UnitAntigens.Count;
					for(int i=0; i<nCount; i++)
						this._bloodAvailability.AddUnitAntigenFilter(dbas.UnitAntigens[i].ToString());
					nCount =dbas.UnitStatuses.Count;
					for(int i=0; i<nCount; i++)
						this._bloodAvailability.AddUnitStatusFilter(dbas.UnitStatuses[i].ToString());
					
					//Populate the special testing filters
					this._bloodAvailability.AddCMVTestingFilter(dbas.CmvTesting);
					this._bloodAvailability.AddSickleCellTestingFilter(dbas.SickleCellTesting);
					
					//Populate the biohazardous and quarantine filters
					this._bloodAvailability.AddBiohazardousFilter(dbas.Biohazardous);
					this._bloodAvailability.AddQuarantineFilter(dbas.Quarantined);

					// Populate the expiration date filters
					this._bloodAvailability.AddExpirationDateAfterFilter(dbas.ExpirationDateAfter);
					this._bloodAvailability.AddExpirationDateBeforeFilter(dbas.ExpirationDateBefore);
					//
					this._bloodAvailability.AddFinalDispositionStartDateFilter(dbas.StartDate);
					this._bloodAvailability.AddFinalDispositionEndDateFilter(dbas.EndDate);
					//
					this._bloodAvailability.CustomReportFilterStatement = this._bloodAvailability.BuildFilterStatement();
				}
				else
				{
					return;
				}
			}
			//
			if (this._bloodAvailability.IsScheduled)
			{
				try
				{
					this._bloodAvailability.Schedule();
					this.DialogResult = DialogResult.Cancel;
					this.Close();
				}
				catch(BOL.BusinessObjectException)
				{
					GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.ScheduleReportFailed());
					return;
				}
			}
			else
			{
				int count = this._bloodAvailability.GetBloodAvailabilityCount();
				if (!this.CheckReportLength(count))
				{
					return;
				}
				//
				DlgReportBloodAvailability dlg = new DlgReportBloodAvailability();
				dlg.MdiParent = this.MdiParent;
				this.Close();
				dlg.Report = this._bloodAvailability;
				dlg.Show();
				//
				
			}
		}

		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}

		private void btnOK_MouseHover(object sender, System.EventArgs e)
		{
			if (this._bloodAvailability.IsValid)
			{
				this.btnOK.SetToolTip(Common.StrRes.Tooltips.Common.OKToContinue().ResString);
			}
			else
			{
				this.btnOK.SetToolTip(this._bloodAvailability.GetBrokenRulesMessage(this.Name));
			}
		}

		private void ReportTypeChanged(object sender, System.EventArgs e)
		{
			this._bloodAvailability.IsDailyInventoryAllReport = this.rdoAllUnits.Checked;
			this._bloodAvailability.IsDailyInventoryAvailableReport = this.rdoAvailableUnits.Checked;
			this._bloodAvailability.IsAntigenTypedInventoryReport = this.rdoAntigenTyped.Checked;
			this._bloodAvailability.IsNoDispositionReport = this.rdoNoDisposition.Checked;
			this._bloodAvailability.IsFinalDispositionReport = this.rdoFinalDisposition.Checked;
			this._bloodAvailability.IsCustomReport = this.rdoCustom.Checked;
			//
			this.dtpStartDate.Enabled = this.rdoFinalDisposition.Checked;
			this.dtpEndDate.Enabled = this.rdoFinalDisposition.Checked;
			//
			// **** 508 Compliance ***
			// Reset the dates
			System.DateTime currentDate = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
			this.dtpStartDate.Value = currentDate.Date.AddDays(-1);
			this.dtpEndDate.Value = currentDate.Date.AddDays(-1);
			//
			// **** 508 Compliance ***
			if (!this.rdoFinalDisposition.Checked)
			{
				this.errError.SetVbecsError(this.dtpEndDate, ""); 
			}
		}

		private void DivisionChanged(object sender, System.EventArgs e)
		{
			this._bloodAvailability.IsMultiDivisional = this.rdoAllDivisions.Checked;
		}

		private void ReportCompilationChanged(object sender, System.EventArgs e)
		{
			this._bloodAvailability.IsScheduled = (this.rdoScheduleJob.Checked);
			this.grpScheduleJob.Enabled = (this.rdoScheduleJob.Checked);
			if ((this._bloodAvailability.IsScheduled) && (this._bloodAvailability.PrintDate == DateTime.MinValue))
			{
				this.dtpPrintDate.Value = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
			}
		}

		private void PatientReportTypeChanged(object sender, System.EventArgs e)
		{
			this._bloodAvailability.IsIndividualPatientReport = this.rdoPatient.Checked;
			this.grpPatient.Enabled = this.rdoPatient.Checked;
			//
			if ((this.rdoPatient.Checked) && (this._bloodAvailability.PatientGuid == Guid.Empty))
			{
				this.btnSelectPatient_Click(sender,e);
			}
			else if (!this.rdoPatient.Checked)
			{
				this._bloodAvailability.PatientGuid = Guid.Empty;
				this.txtPatientName.Text = "";
				this.txtPatientID.Text = "";
			}
		}

		private void btnSelectPatient_Click(object sender, System.EventArgs e)
		{
			FrmPatientSelect dlg = new FrmPatientSelect(false);
			if (dlg.ShowDialog(this) != DialogResult.OK)
			{
				return;
			}
			this._bloodAvailability.PatientGuid = dlg.SelectedPatient.PatientGuid;
			this.txtPatientName.Text = dlg.SelectedPatient.DisplayName;
			this.txtPatientID.Text = dlg.SelectedPatient.DisplayPatientID;
		}

		private void CheckDates()
		{
			if ((this._bloodAvailability.IsFinalDispositionReport) && (this._bloodAvailability.FinalDispositionStartDate > this._bloodAvailability.FinalDispositionEndDate))
			{
				this.errError.SetVbecsError(this.dtpEndDate, Common.StrRes.SysErrMsg.Common.CannotbeGreaterError("Start date","End date").ResString); // **** 508 Compliance ***
			}
			else
			{
				this.errError.SetVbecsError(this.dtpEndDate, ""); // **** 508 Compliance ***
			}
			//
			if (this._bloodAvailability.IsScheduled)
			{
				if ((this._bloodAvailability.IsFinalDispositionReport) && (this._bloodAvailability.FinalDispositionEndDate > this._bloodAvailability.PrintDate))
				{
					this.errError.SetVbecsError(this.dtpPrintDate, Common.StrRes.SysErrMsg.Common.CannotbeLessError("Print date","End date").ResString); // **** 508 Compliance ***
				}
				else
				{
					this.errError.SetVbecsError(this.dtpPrintDate, ""); // **** 508 Compliance ***
				}
			}
			else
			{
				this.errError.SetVbecsError(this.dtpPrintDate, ""); // **** 508 Compliance ***
			}
		}

		private void StartDateChanged(object sender, System.EventArgs e)
		{
			this._bloodAvailability.FinalDispositionStartDate = this.dtpStartDate.Value;
			//
			CheckDates();
		}

		private void EndDateChanged(object sender, System.EventArgs e)
		{
			this._bloodAvailability.FinalDispositionEndDate = this.dtpEndDate.Value;
			//
			CheckDates();
		}

		private void dtpEndDate_EnabledChanged(object sender, System.EventArgs e)
		{
			if (this.dtpEndDate.Enabled)
			{
				this.dtpEndDate.CustomFormat = Common.VBECSDateTime.DateFormat;
			}
			else
			{
				this.dtpEndDate.CustomFormat = " ";
			}
		}

		private void dtpStartDate_EnabledChanged(object sender, System.EventArgs e)
		{
			if (this.dtpStartDate.Enabled)
			{
				this.dtpStartDate.CustomFormat = Common.VBECSDateTime.DateFormat;
			}
			else
			{
				this.dtpStartDate.CustomFormat = " ";
			}
		}

		/// <summary>
		/// **** 508 Compliance ***
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void DlgPatientAvailabilityType_KeyDownSpeakMessage(object sender, EventArgs e)
		{
			string textToSpeak = string.Empty;
			//
			if (!this._bloodAvailability.IsValid)
			{ 
				textToSpeak = this._bloodAvailability.GetBrokenRulesMessage(this.Name);
			}
			//
			this.SpeakMessage( textToSpeak );
		}
	}
}